<?php
    /*
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    $templateSorgente = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
    
    // il template email n 1 è il template sorgente, da cui Geecom prende i dati base per i nuovi template
    $queryTemplateEmail = "SELECT * FROM geec_templateEmail WHERE id>1";
    $risTemplateEmail   = $geecomDb->eseguiQueryLettura($queryTemplateEmail);
    
    $idTemplate = isset($_GET["idTemplate"]) ? filter_input(INPUT_GET,"idTemplate",FILTER_SANITIZE_NUMBER_INT) : 2;
    
?>
<h4 class="mb-4 title">Template email</h4>
<ul class="nav nav-pills" id="..." role="tablist">
    <?php 
        while($templateEmail = $risTemplateEmail->fetch_assoc()) {
            
            $stringaAttivo = ($templateEmail["id"] == $idTemplate) ? "active" : "";
    ?>
    <li class="nav-item" role="presentation">
        <a class="nav-link <?php echo $stringaAttivo ?>" data-toggle="pill" href="#template<?php echo $templateEmail["id"] ?>" role="tab" aria-controls="pills-home" aria-selected="true"><?php echo $templateEmail["nome"] ?></a>
    </li>
    <?php
        }
    ?>
    <li class="nav-item" role="presentation">
        <a class="nav-link btn btn-sm btn-outline-primary ml-3" data-toggle="pill" href="#nuovoTemplate" role="tab" aria-controls="pills-home" aria-selected="true">Aggiungi nuovo<i class="fas fa-plus ml-2"></i></a>
    </li>
</ul>

<div class="tab-content">
    <?php 
        // il template email n 1 è il template sorgente, da cui Geecom prende i dati base per i nuovi template
        $queryTemplateEmail = "SELECT * FROM geec_templateEmail WHERE id>1";
        $risTemplateEmail   = $geecomDb->eseguiQueryLettura($queryTemplateEmail);
        while($templateEmail = $risTemplateEmail->fetch_assoc()) {
            $stringaAttivo = ($templateEmail["id"] == $idTemplate) ? "active" : "";
    ?>
        <div id="template<?php echo $templateEmail["id"] ?>" class="tab-pane fade show px-0 shadow-none <?php echo $stringaAttivo ?>" role="tabpanel">
            <form class="form-horizontal" role="form" name="formImpostazioniTemplateEmail<?php echo $templateEmail["id"] ?>" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
                <input type="text" class="d-none" name="operazione" value="aggiornaTemplateEmail">
                <input type="text" class="d-none" name="id" value="<?php echo $templateEmail["id"] ?>">

                <div class="mb-3">
                    <h6>Nome</h6>
                    <input type="text" class="form-control" name="nome" value="<?php echo $templateEmail["nome"] ?>">
                </div>
                <div class="mb-3">
                    <h6>CSS</h6>
                    <textarea class="form-control" rows="15" id="css" name="css"><?php echo $templateEmail["css"] ?></textarea>
                </div>
                <div class="mb-3">
                    <h6>Corpo</h6>
                    <textarea class="form-control" rows="15" id="testoFooter" name="corpoMail"><?php echo $templateEmail["corpoMail"] ?></textarea>
                </div>
                <div class="mb-0">
                    <h6>Footer</h6>
                    <textarea class="form-control" rows="15" id="testoFooter" name="footerMail"><?php echo $templateEmail["footerMail"] ?></textarea>
                </div>
                <button type="button" class="btn btn-primary float-right ml-3 mt-3" onclick="document.formImpostazioniTemplateEmail<?php echo $templateEmail["id"] ?>.submit()"><i class="fas fa-check"></i> Salva </button>
            </form>
        </div>
    <?php
        }
    ?>
    <div id="nuovoTemplate" class="tab-pane fade show px-0 shadow-none" role="tabpanel">
        <form class="form-horizontal" role="form" name="formNuovoTemplateEmail" action="../controller/controllerImpostazioni.php" method="post" enctype="multipart/form-data">
            <input type="text" class="d-none" name="operazione" value="creaTemplateEmail">
            <input type="text" class="d-none" name="id" value="0">

            <div class="mb-3">
                <h6>Nome</h6>
                <input type="text" class="form-control" name="nome" value="">
            </div>           
            <div class="mb-3">
                <h6>CSS</h6>
                <textarea class="form-control" rows="15" id="css" name="css"><?php echo $templateSorgente["css"] ?></textarea>
            </div>

            <div class="mb-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Personalizza colori</label>
                    <input type="checkbox" class="js-switch" id="checkboxPersonalizzaColori" name="personalizzaColoriTemplateMail" value="si" onchange="mostraDivPersonalzzazioniColoriMail()" />
                </div>
                
                <div id="divPersonalizzazioniColori" class="d-none">
                    <div class="col-md-4 col-xl-3">
                        <label>Colore di sfondo </label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimario" name="coloreSfondoMail" value="<?php echo $configurazioneColore["colorePrimario"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                    </div>

                    <div class="col-md-4 col-xl-3">
                        <label>Colore intestazione </label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimario" name="coloreIntestazioniMail" value="<?php echo $configurazioneColore["colorePrimario"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                    </div>

                    <div class="col-md-4 col-xl-3">
                        <label>Colore link </label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimario" name="coloreLink" value="<?php echo $configurazioneColore["colorePrimario"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                    </div>

                    <div class="col-md-4 col-xl-3">
                        <label>Colore link hover</label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimario" name="coloreLinkHover" value="<?php echo $configurazioneColore["colorePrimario"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <h6>Intestazione</h6>
                <div class="form-group col-md-4">
                    <label for="nome-voce-menu-3">Tipo</label>
                    <select class="form-control" id="tipoIntestazioneTemplateMail" name="tipoIntestazioneTemplateMail" onchange="mostraElementiCreazioneIntestazioneMail()">
                        <option value="" >Seleziona</option>
                        <option value="imgCentrata" >Immagine centrata</option>
                        <option value="imgTuttaLarghezza" >Immagine </option>
                        <option value="testo" >Testo </option>
                    </select>
                </div>
                
                <div id="divImmagineIntestazione" class="d-none">
                    <label>Immagine</label>
                    <input type="file" name="immagineIntestazione">
                </div>
                
                <div id="divTestoIntestazione" class="">
                    <textarea class="form-control" rows="15" id="testoFooter" name="intestazioneMail"></textarea>
                </div>
            </div>
            
            <div class="mb-3">
                <h6>Corpo</h6>
                <textarea class="form-control" rows="15" id="testoFooter" name="corpoMail"><?php echo $templateSorgente["corpoMail"] ?></textarea>
            </div>
            
            <div class="mb-0">
                <h6>Footer</h6>
                <div class="form-group col-md-4">
                    <label for="nome-voce-menu-3">Tipo</label>
                    <select class="form-control" id="tipoFooterTemplateMail" name="tipoFooterTemplateMail" onchange="mostraElementiCreazioneFooterMail()">
                        <option value="" >Seleziona</option>
                        <option value="imgCentrata" >Immagine centrata</option>
                        <option value="imgTuttaLarghezza" >Immagine </option>
                        <option value="testo" >Testo </option>
                    </select>
                </div>
                
                <div id="divImmagineFooter" class="d-none">
                    <label>Immagine</label>
                    <input type="file" name="immagineFooter">
                </div>
                
                <div id="divTestoFooter" class="">
                    <textarea class="form-control" rows="15" id="testoFooter" name="footerMail"><?php echo $templateSorgente["footerMail"] ?></textarea>
                </div>
            </div>
            
            <div class="footer">
                <button type="button" class="btn btn-primary float-right" onclick="document.formNuovoTemplateEmail.submit()"><i class="fas fa-check"></i> Crea </button>
            </div>
        </form>
    </div>
</div>